START NOPAGE NOLIST
;*****************************************************************************
;
;       GLFILE.DSC      General Ledger File definitions.
;
;       SIM Automated Business System.
;
;       Written by Tom Hale, John Dudeck.
;       SIM International, Charlotte, NC 28217
;
;*****************************************************************************
;
;       Updated to General Ledger Release V5.30b
;       Charlotte, June, 1994  JRD
;
;	Revisions:
;	13-Sep-88	London		JRD
;	Separated GLAMAS portion into GLAMAS.DSC for use by Donor package.
;	9-Jun-94	Charlotte	JRD
;	Added Lynn's GLBTCH definitions.
;	26-Jun-94	Lausanne	JRD
;	Moved GLBTCH defs to GLBTCH.DSC
;	27-Jul-94	Charlotte	JRD
;	Remove use of GLBTCH source code list.
;
;*****************************************************************************
.INCLUDE GL0:GLAMAS.DSC
;
; General Ledger WORK is a temporary holding file in ISAM format to hold
;       the transactions until they are posted to YTDGLT.
;
;               File Name: GL2:GLWORK.ISM
;               Type: ISAM
;               Record Length: 103
;               Key Length: 12
;               Key Position: 1
;               Duplicates added at end, ascending sequence
;
RECORD GLWORK
		,A2             ;COMPANY NUMBER
    WKACNO      ,D12            ; Account Number
    WKDATE      ,D6             ; Date of transaction
    WKAMT       ,D10            ; Amount of Transaction
    WKSRCE      ,A5             ; Batch Code
    WKREF       ,A30            ; Description of Transaction
    WKCODE      ,D13            ; Distribution Code
    WKUNIT      ,D7             ;
    CRRNCY      ,A3             ; The currency of transaction
    WKRATE      ,D11            ; The rate of exchange
    WKITEM      ,D3             ; The Item Number in the Batch
    DELFLG      ,A1             ; Has this transaction been posted?
RECORD  ,X
    GLWKEY      ,A14
;
; Year To Date General Ledger Transactions is the file that contains all of
;       the activity for the present year
;
;               File Name: GL2:YTDGLT.ISM
;               Type: ISAM
;               Record Length: 65
;               Key Length: 14
;               Key Position: 1
;               Duplicates added at end, ascending sequence
;
RECORD YTDGLT
		,A2             ; Company Number
    GLACNO      ,D12            ; G/L Account Number
    GLDATE      ,D6             ; Transaction Date
    GLAMT       ,D10            ; Amount of transaction
    GLSRCE      ,A5             ; The Batch Code of the Transaction
    GLREF       ,A30            ; Transaction Description
RECORD  ,X
    YTDKEY      ,A14
;
START NOPAGE LIST
