START NOPAGE NOLIST
;*****************************************************************************
;
;	JCFILE.DSC	Job Control file definitions.
;
;	SIM Automated Business System.
;
;	Written by Tom Hale, John Dudeck.
;	SIM International, Charlotte, NC 28217
;
;*****************************************************************************
;
;	Updated to Job Control Release V2.1
;	California, June, 1987	JRD
;
;	Revisions:
;		4-Jun-87	California	JRD
;		Remove unsupported field names from COMAST.
;		New OUTMAS record format to support system-wide
;		output device definition.
;		Remove unsupported field names from SECMAS.
;
;*****************************************************************************
;
; COmpany MASTer is the file that contains the information about all
; users within a particular company.
;
;		File Name: JC2:COMAST.ISM
;		Type: ISAM
;		Record Length: 478
;		Key Length: 2
;		Key Position: 1
;		No duplicates, ascending sequence
;
RECORD COMAST
    COMPNO	,D2		; Company number
    CONAME	,A50		; Company name
    ,A16			; Reserved
    OPID	,10A6		; Operator ID (Password)
    OPNAME	,10A20		; Operator name
    PPN1	,10D6		; Operator project number (PPN)
    PPN2	,10D6		; Operator personal number (PPN)
    OPCLR	,10D2		; Operator clearance
    ,A10			; Reserved
RECORD	,X
    COKEY	,A2		; Key field
;
;  OUTput MASter is the file that contains the output device information.
;
;		File Name: JC2:OUTMAS.ISM
;		Type: ISAM
;		Record Length: 100
;		Key Length: 2
;		Key position: 1
;		No duplicates, ascending sequence
;
RECORD OUTMAS
    ODEVNUM	,D2		; Output DEVice NUMber
    ODEVSPEC	,A20		; Output DEVice SPECification
    PROMPT	,A20		; Screen PROMPT
    SYSLINE	,D2		; SYStem LINE number requiured (0 = all lines)
    OSECUR	,D1		; User Output SECURity level required.
    OENABLE	,D1		; Output device ENABLE flag ($TRUE=enable)
    OPGPRNT	,D2		; Output lines per PaGe to PRiNT
    ,A7				; Reserved
    STELIT	,A15		; STart ELITe print escape sequence
    STCOMP	,A15		; STart COMPressed print escape sequence
    FINISH	,A15		; FINISH-up escape sequence
RECORD	,X
    OUTKEY	,A2
;
; Record used to hold security level for programs needing special
; security levels.
;
;		File Name: JC2:SECMAS.ISM
;		Type: ISAM
;		Record Length: 22
;		Key Length: 16
;		Key Position: 1
;		No duplicates, ascending sequence
;
RECORD PROGRM
    ,A2
    PNAME	,A14		; Program name
    RO		,D1		; Program Read Only security level
    RW		,D1		; Program Read/Write security level
    ,A4				; Reserved
RECORD	,X
    JCKEY	,A16		; Key field
START NOPAGE LIST
