START NOPAGE NOLIST
;*****************************************************************************
;
;	USER.DSC	User system configuration module.
;
;	SIM Automated Business System.
;
;	Written by Tom Hale, John Dudeck.
;	SIM International, Charlotte, NC 28217
;
;*****************************************************************************
;
;	Updated to Job Control Release V2.15a
;	Niamey, May, 1989	JRD
;
;*****************************************************************************
;
;	Following are a series of variables and questions to be used to
;	tailor the SIM Accounting Package to better meet local needs.
;
;	Instructions:
;	To enable an item, delete the semicolon (the ; symbol) from the
;	first position of the line in which the item is displayed.
;	To disable an item, type a semicolon in the first position
;	of the line.  Please DO NOT delete any lines out of this file.
;
;*****************************************************************************
;
;	System package selection.
;
; 	There are several packages now available in the SIM Automated
;	Business System.  The following variables tell which packages
;	are to be included in your installation.  This is used during
;	the generation process for the interfaces between the packages.
;
;.DEFINE CV	; CoVenant Maintenance Package
.DEFINE DN	; DoNor Acknowledgement Package
.DEFINE GL	; General Ledger Package
;.DEFINE IN	; INventory System
;.DEFINE PB	; Patient Billing System
;.DEFINE PR	; PayRoll System
;.DEFINE SB	; SIM Billing Package (not yet developed)
;.DEFINE SR	; SeRvices Division System (Used at ELWA)
;.DEFINE UB	; Utility Billing System (Used at ELWA)
;
;*****************************************************************************
;
;	Compiler and operating system selection.
;
;       These versions depend on the type of operating system and on the
;       date of the release.  The following will cause the compiler to 
;       select the appropriate code according to each site's version.
;
;.DEFINE V2	; To be used in sites running with DBL V2.2
.DEFINE V4	; To be used in sites running with DBL V4
;
.DEFINE MSDOS  ; To be used in sites running MS-DOS
;.DEFINE RT11	; To be used in sites running the RT-11 Operating System
;.DEFINE TSX     ; To be used in sites running the TSX Timesharing System
;
;*****************************************************************************
;
;	Date format.
;
;       To work in the European Format (DD.MM.YY) enable the following line:
;               .DEFINE EUROPE
;       To work in the US Date Format (MM/DD/YY) include the following line:
;               .DEFINE US
;
.DEFINE EUROPE
;.DEFINE US
;
;*****************************************************************************
;
;	Language selection.
;
;	The reports and screens are available in French as well as English.
;       To get French, the following line should be included:
;               .DEFINE FRENCH
;       Otherwise, English should be selected:
;               .DEFINE ENGLISH
;
;.DEFINE FRENCH
.DEFINE ENGLISH
;
;*****************************************************************************
;
;	Decimal point/comma selection.
;
;	To use the period as the decimal symbol, with commas to separate
;	thousands, (e.g. 1,234,567.89), enable the following line:
;		.DEFINE PERIOD
;	To use the comma as the decimal symbol, with periods to separate
;	thousands, (e.g. 1.234.567,89), the line is:
;		.DEFINE COMMA
;
.DEFINE PERIOD
;.DEFINE COMMA
;
;*****************************************************************************
;
;	Currency exchange rate format.
;
;	The foreign currency exchange rate may be expressed as the ratio of
;	Base to Foreign or as Foreign to Base.
;	To express exchange rate as Base to Foreign,
;	e.g. for base of SFr, to express SFr per dollar:
;		.DEFINE BASFOR
;	To express exchange rate as Foreign to Base,
;	e.g. for Base SFr, to express dollars per SFr:
;		.DEFINE FORBAS
;
.DEFINE BASFOR
;.DEFINE FORBAS
;
;	Exchange rate multiplier.
;
;	In cases where the base currency is in a different format from
;	the foreign currencies used, it is easier to represent the exchange
;	rate if it is scaled by 100.  Exchange rate is normally expressed
;	as the ratio of the smallest units of currency.  For example,
;	when the base is in CFA, without scaling you would give the exchange
;	rate as CFA per penny.  However, to express CFA per dollar, which is
;	preferable, the rate must be multiplied by 100.  Note that this is
;	a globally defined multiplier, and applies to all currencies used.
;
;	To multiply the exchange rate by 100:
;		.DEFINE EXM100
;	If the exchange rate is not to be scaled, EXM100 should not
;	be defined.
;
.DEFINE EXM100
;
;*****************************************************************************
;
;	Budget multiplier.
;
;	The budget figures for an account can be stored as a number that
;	will be multiplied by 100, to give whole dollars, etc,
;	or can be displayed as entered, such as for CFA francs.
;
;	To cause budget figures to be multiplied by 100, enable the
;	following line:
;		.DEFINE BUD100
;
;.DEFINE BUD100
;
;*****************************************************************************
;
;	Control-C abort enable.
;
;	When running under some multi-user systems, allowing someone to
;	abort a program with a Control-C allows a breach in the security
;	system.  To enable Control-C abort, include:
;		.DEFINE CTRLC
;
.DEFINE CTRLC
;
;*****************************************************************************
;
;	Donor Package placement of Postal Code.
;
;	The Postal Code may be placed before or after the last line
;	of the address when printing reports.
;
;.DEFINE PCBEFORE
.DEFINE PCAFTER
;
;*****************************************************************************
;	Programmer's Note:  No storage definitions will be compiled
;	if the program which uses this file has defined the symbol DEFONLY.
.IFNDEF DEFONLY
;*****************************************************************************
.IFDEF GL
;*************************************************************************;
;                                                                         ;
; The following section is used for those with the General Ledger Package ;
;                                                                         ;
;*************************************************************************;
;
;	Companies have different strategies for their accounting systems.
;	In some places there are two digits in the major account code,
;	followed by four or five digits in the sub-code.  The package is
;	built to handle up to six in the major code and six in the minor code.
;	To select this, set the number of digits for MAJOR and MINOR:
;
RECORD
    MAJOR	,D1	,2	;Set the major code to two digits
    MINOR	,D1	,5	;Set the minor code to five digits
;
;*****************************************************************************
;
;	An Accounting Center (also known as Profit Center) may have reports
;	generated for it as a sub-entity of the company.
;
;	Accounting centers are designated by one or more digits of the
;	account number.  ACCSTR is the position of the starting digit
;	and ACCEND the position of the ending digit desired to designate the
;	Accounting Center.
;
;	Example: Company XYZ uses the 10th and 11th digits of the account
;	number to designate its Accounting Centers.
;	ACCSTR	,D2	,10
;	ACCEND	,D2	,11
;
;  If there are no ACCounting centers, set ACCSTR and ACCEND to 0.
RECORD
    ACCSTR	,D2	,0
    ACCEND	,D2	,0
;
;*****************************************************************************
;
;	The first character(s) of the SCHedule CoDE (SCHCDE) in GLAMAS are
;	used to designate the number of the Schedule on which they appear.
;	The following characters are used to define the 'line' of the
;	Schedule that they appear on. The last two characters define
;	the type of account it is. SCHDIGIT allows the system manager 
;	to decide how many of the first characters will be used for Schedule
;	Number and the remaining will be used for the line number.
;
;	Note:  Allowable values of SCHDIGIT are 1 and 2.
;
;	Example:
;	SCHDIGIT	,D1	,2	; SCHCDE format of SSLLLTT
RECORD
;    SCHDIGIT	,D1	,1		; SCHCDE format of SLLLLTT
    SCHDIGIT 	,D1	,2		; SCHCDE format of SSLLLTT
;
;*****************************************************************************
;
;	The first digit(s) of the SCHedule CoDE designate which Schedule
;	and format an account will be reported on.  There are two formats
;	that the Schedules are output in: Income and Expense Format
;					  Balance Sheet Format.
;	SCHBReaK allows you to decide how many numbers should be designated
;	for each type.  Schedule numbers up through SHCBRK will be in
;	I/E format, and Schedule numbers above SCHBRK will be in 
;	Balance sheet format.
;
;	  Example:
;	    SCHBRK	,D2	,50
;	sets Schedules 01 to 50 to be in the Income and	Expense Format
;	and 51 to 99 to be in the Balance Sheet format.
;
;  PLEASE NOTE: SCHBRK must be less than the maximum number allowed by
;		SCHDIGIT above.  If SCHDIGIT is 2, SCHBRK CAN NOT
;		be greater than 99.
RECORD
    SCHBRK	,D2	,50
;
;*****************************************************************************
;
;	Foreign Currency Batch Offset Limit.
;
;	When General Ledger transaction batches contain foreign currency
;	transactions, it is possible to have different exchange rates used
;	for the debit and credit side of the transaction.  When this occurs,
;	the batch may not balance.  The system will automatically make the
;	batch to balance by posting a balancing transaction to the exchange
;	fluctuation account that is defined for the company, after approval
;	by a user with supervisorial clearance.
;
;	It is necessary to define the limit in percent that a batch may be
;	out of balance before the system will not permit the batch to be
;	posted with automatic offset correction.  If you will always manually
;	balance foreign batches, set the limit to a small value such as 1%,
;	which will allow for roundoff.  However, if you wish to allow the
;	system to balance foreign batches, set the limit to a larger number,
;	perhaps 25%.
;
;	The limit is expressed in tenths of percent.  For example,
;	1.5% would be entered as 15.
;
RECORD
;    OFFLIM	,D6	,9		; .9% offset limit.
    OFFLIM	,D6	,100		; 10.0% offset limit.
;    OFFLIM     ,D6     ,5
;
.ENDC
;*************************************************************************;
;									  ;
; The following section is used by those with the Inventory Package	  ;
;									  ;
;*************************************************************************;
;
.IFDEF IN
;
;	Different companies will use different Inventory numbering schemes.
;	To allow maximum flexibility, the ten digit inventory code
;	is split into two sections, the MAJOR number and the MINOR.
;	By setting the following variables, one can decide the number
;	of digits in each.  For example, to have the inventory scheme
;	look:
;		AB-12345678
;	the variables would read:
;
;	INMAJOR	,D1	,2
;	INMINOR	,D1	,8
RECORD
    INMAJOR	,D1	,2
    INMINOR	,D1	,8
;
;	It is possible to select by up to five different selection criteria
;	on the report generator.  Most companies will not use this many.  
;	The following variable allows you to choose the MAX number
;	SELection criteria.
;
RECORD
    MAXSEL	,D1	,5
;
; It is possible to have up to three different selling prices for each item 
;	inventory. This variable tells the system how many there will be
;
RECORD
    MAXPRI	,D1	,3
.ENDC
;
;*************************************************************************;
;									  ;
; The following section is used by those with the Patient Billing Package ;
;									  ;
;*************************************************************************;
;
.IFDEF PB
;
;	Different companies will use different numbering schemes.
;	To allow maximum flexibility, the ten digit inventory code
;	is split into two sections, the MAJOR number and the MINOR.
;	By setting the following variables, one can decide the number
;	of digits in each.  For example, to have the inventory scheme
;	look:
;		AB-12345678
;	the variables would read:
;
;	PBMAJOR	,D1	,2
;	PBMINOR	,D1	,8
RECORD
    PBMAJOR	,D1	,3
    PBMINOR	,D1	,7
;
.ENDC
;*************************************************************************;
;									  ;
; The following section is used by those with the Services Billing Package;
;									  ;
;*************************************************************************;
;
.IFDEF SR
; 
;	Different companies will use different numbering schemes.
;	To allow maximum flexibility, the ten digit JOB code
;	is split into two sections, the MAJOR number and the MINOR.
;	By setting the following variables, one can decide the number
;	of digits in each.  For example, to have the JOB scheme
;	look:
;		AB-12345678
;	the variables would read:
;
;	SRMAJOR	,D1	,2
;	SRMINOR	,D1	,8
RECORD
    SRMAJOR	,D2	,10
    SRMINOR	,D1	,0
.ENDC
;
;*************************************************************************;
;									  ;
; The following section is used by those with the Donor Package.	  ;
;									  ;
;*************************************************************************;
;
.IFDEF DN
; 
;	Different companies will use different numbering schemes.
;	To allow maximum flexibility, the ten digit Donor code
;	is split into two sections, the MAJOR number and the MINOR.
;	By setting the following variables, one can decide the number
;	of digits in each.  For example, to have the JOB scheme
;	look:
;		AB-12345678
;	the variables would read:
;
;	DNMAJOR	,D1	,2
;	DNMINOR	,D1	,8
RECORD
    DNMAJOR	,D2	,10
    DNMINOR	,D1	,0
;
;*************************************************************************;
;
;	Name of LEX DONOR vmf.
;
;	Different sites have named their DONOR.VMF differently.
;	Select the name corresponding to your installation.
;
RECORD
    DNRVMF     ,A14    ,'DN3:DONOR.VMF'        ;Normally used
;    DNRVMF      ,A14    ,'DN3:DONOR.VM9'        ;London
;    DNRVMF	,A14	,'DN3:DONOR.NEW'	;Lausanne
;
.ENDC
;*************************************************************************;
;
; The following section is used by those with the Covenant Package.
;
;*************************************************************************;
.IFDEF CV
;
; The sixteen digit Donor Key and Covenant no. is split into two sections.
;	To have the key look:
;		ABCDEFGHIJ-123456
;	the variables would read:
;		CVMAJOR	,D2	,10
;		CVMINOR	,D1	,6
RECORD
    CVMAJOR	,D2	,10
    CVMINOR	,D1	,6
.ENDC
;
;***********************************************************************;
;									;
; Default program security levels.					;
;									;
;***********************************************************************;
;
;	Each program in the system may have security clearances assigned to it
;	by setting up the program in the SeCurity MASter file.
;	The following definitions are the default security levels that will
;	be used by the system when no entry has been made in SECMAS for a
;	program.  In this way, it is not necessary to set up SECMAS for any
;	of the programs.
;	If security levels different from the defaults are desired for a
;	given program, only that program need be set up in SECMAS.
;
RECORD SECDFLT
    ,D1		,3	; Default RO (Read-Only) level (Recommended: 3)
    ,D1		,5	; Default RW (Read-Write) level (Recommended: 5)
;
;***********************************************************************;
;									;
; Output Device Definitions.						;
;									;
;***********************************************************************;
;
;	If you are looking for printer defintions, this has been
;	eliminated from USER.DSC.  Output devices are set by the user
;	in the Job Control package output device maintenance program.
;
;	If there are no devices specified by the user, the system will
;	automatically use a default menu.  The default menu will be in
;	the language selected.
;
;	If you need to modify the default menu it can be found in RDYPR.XBL,
;	but it is recommended that this only be done by a DBL programmer.
;
;*****************************************************************************
;									     ;
;		This marks the end of the user definable area.		     ;
;									     ;
;*****************************************************************************
;									     ;
;  >>> NOTICE:  THE FOLLOWING SECTION IS NOT TO BE CHANGED BY THE USER. <<<  ;
;									     ;
;*****************************************************************************
;
;	Default flags definition.
RECORD
.IFDEF CTRLC
    ,D1	,0	; Enable ^C.  Do not change.
.IFF
    ,D1	,1	; Disable ^-C.  Do not change.
.ENDC
    ,D1	,0	; Stop msg.  Do not change.
    ,D1	,0	; Suppress ^Z.  Do not change.
    ,D1	,0	; Echo.  Do not change.
    ,D1	,1	; Scope.  Do not change.
    ,D1	,0	; Noreplace.  Do not change.
    ,D1	,0	; Upper/lower.  Do not change.
.IFDEF COMMA
    ,D1	,1	; Decimal comma.  Do not change.
.IFF
    ,D1	,0	; Decimal period.  Do not change.
.ENDC
RECORD	,X
    FLAG1	,A8
;
;*****************************************************************************
;	
; Global Memory region.
; Used to pass Security and Output Device information between routines.
;
GLOBAL SECTION SECURE
RECORD FIELDS
    CPNO	,A2	; Company number
    CPNAM	,A50	; Company name
    OPNO	,D2	; Operator's number
    OPNAM	,A30	; Operator name

    DVOUT	,A14	; Output device specification
    DVFIN	,A15	; Finish-up escape sequence to use
    PGPRNT	,D2	; Number of lines to print per page

    USEPR	,D1	; Current User Program Security Level
    USEOT	,D1	; Current User Output Security Level

    PRGRO	,D1	; Current Program Read Only Security
    PRGRW	,D1	; Current Program Read/Write Security
ENDGLOBAL
;
; Variables used to put the date into international format.
;
RECORD
.IFDEF FRENCH
    MONTH	,12A3,'JAN','FEV','MAR','AVR','MAI','JUI','JUL','AOU','SEP','OCT','NOV','DEC'
.ENDC
.IFDEF ENGLISH
    MONTH	,12A3,'JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC'
.ENDC
;
; Masks used throughout the packages.
;
RECORD
    MASKAC	,A13,'ZZZZXX-XXXXXX'		;Account number mask
    MASKPT	,A5,'ZZX %'			;Percentages mask
    MASKMJR	,A6,'ZZZZXX'			;Major account number mask
.IFDEF COMMA
    MASKRT	,A12,'ZZZZX,XXXXXX'		;Exchange rate mask
    MASKAM	,A15,'ZZZ.ZZZ.ZZZ,XX-'		;Default amount mask
;    MASKAM	,A15,'ZZ.ZZZ.ZZZ.ZZZ-'		;NIAMEY'S MASKAM
.IFF
    MASKRT	,A12,'ZZZZX.XXXXXX'		;Exchange rate mask
    MASKAM	,A15,'ZZZ,ZZZ,ZZZ.XX-'		;Default amount mask
.ENDC
.IFDEF US
    MASKDT	,A8,'XX/XX/XX'			;US Date format mask
.ENDC
.IFDEF EUROPE
    MASKDT	,A8,'XX.XX.XX'			;European Date format mask
.ENDC
;
; CURrency INFormation contains information about all of the Memo Accounts.
;	
;		File Name: JC2:CURFLE.ISM
;		Type: ISAM
;		Record Length: 58
;		Key Length: 5
;		Key Position: 1
;		Duplicates added at end, ascending sequence
;
RECORD CURINF
    CURCMP	,A2		;Company number
    CURTTL	,A3		;Currency abbreviation
    CURATE	,D11		;Rate of exchange (90000000000=Base)
    ACCNT	,D12		;Memo account posted to when currencies change
    MASKCR	,A15		;Mask to be used with this currency
		,A15		;Reserved
RECORD	,X
    CURKEY	,A5
;
; ACcounTing PeRioD is a sequential file that contains the Accounting Periods
; for the present fiscal year.
;
;		File Name: JC2:ACTPRD.D??
;		Type: Sequential
;
RECORD ACTPRD
    GLSTDT	,13D6
    GLENDT	,13D6
    CLSPRD	,13D1
;
; A record that is a common length is needed between all of the packages, 
;	especially for PSTSET which is maintained by JC package and each
;	other package.
;
RECORD
    CMMN	,A30
;
; The value of ESCape is defined here.
    ESC		,D2	,27
; The following .ENDC is to close the .IFNDEF DEFONLY conditional.
.ENDC
;
START NOPAGE LIST
