/*
 * dbl.h
 * include file for DBL XCALL subroutines written in C.
 *
 * On invocation of subroutine, arguments are passed as follows:
 *	# args            <-- input arg points here
 *	ptr to first arg descriptor block
 *	ptr to second arg descriptor block
 *	etc.
 *
 * DBL argument (i.e. variable) descriptor blocks are as follows:
 *	flags	(byte)
 *	class	(byte)
 *	length	(word)
 *	pointer	(word)
 *
 * where flags are as follows:
 *	7	set if global or common
 *	3-0	# digs to right of decimal (fixed pt only)
 *
 * and class is as follows:
 *	7	set if literal
 *	5,4	if either set, temp variable
 *	2	set if alpha
 *	1	set if fixed-point
 *	0	set if decimal
 *
 */

typedef struct {	/* Structure definition for DBL data descriptor */
       short d_flags;
       short d_len;
       char *d_addr;
   } DESCRIP;

#define DECML 0x0100	/* bit values for d_flags */
#define FIXPT 0x0200
#define ALPHA 0x0400
#define LITRL 0x8000

/*
 * DBL Runtime Error definitions for use by rerror() function.
 * Note that the C error code differs from the DBL error code.
 * Each comment gives English message, DBL code,
 * and Informational, Fatal (trappable), or Unconditional class.
 */

#define ACCVIO 0 /* Access violation 200 I */
#define ALITXP 1 /* Alpha literal expected 201 I */
#define AORDXP 2 /* Alpha or decimal variable expected 202 I */
#define ARGORD 3 /* Arguments out of order for PAK or UNPAK 77 F */
#define ARGREC 4 /* PAK/UNPAK fields not in record 78 F */
#define ARGSIZ 5 /* Invalid argument size 31 U */
#define BADDIG 6 /* Invalid numeric digit in variable 20 F */
#define BADDPK 7 /* Bad digit in PAK/UNPAK 79 F */
#define BADIND 8 /* Bad index: %d 203 I */
#define BADLEN 9 /* Bad length specification in SCAN or REPLACE 204 U */
#define BADPTR 10 /* Invalid string pointer value 205 U */
#define BADRNG 11 /* Bad range value: %d, %d 206 I */
#define BADSPC 12 /* Bad file specification 17 F */
#define BLKSIZ 13 /* Block size must be a multiple of 512 207 I */
#define CCABRT 14 /* Control-C abort 98 F */
#define CHNBSY 15 /* Channel already in use 16 U */
#define CHNNOP 16 /* Channel not open 11 U */
#define CHNSPC 17 /* Channel specified was: %u 208 I */
#define CHRSPC 18 /* Character specified was: %c 209 I */
#define COLEQL 19 /* Colon or equal sign expected 210 I */
#define DECXP 20 /* Decimal expected 211 I */
#define DIVZER 21 /* Arithmetic trap, divide by zero 30 F */
#define DRCSIZ 22 /* Destination record size: %d 212 I */
#define ENDOFF 23 /* End of file 1 F */
#define EQLEXP 24 /* Equal sign expected 213 I */
#define ERTEXT 25 /* %s 214 I */
#define EXCACT 26 /* Too many activation characters 113 U */
#define FILSPC 27 /* File specification was: %s 216 I */
#define ILLKEY 28 /* Illegal key 52 F */
#define ILRCNM 29 /* Illegal record number 28 F */
#define INCCOM 30 /* Incompatible compiler 29 U */
#define INSMEM 31 /* Not enough memory 9 U */
#define INVCMD 32 /* Invalid I/O command: %s 217 I */
#define INVCNM 33 /* Invalid channel number 10 U */
#define INVENT 34 /* Illegal entry into FOR statement 130 U */
#define INVERR 35 /* Undefined error 218 F */
#define INVFNM 36 /* Invalid filename 219 F */
#define INVFOR 37 /* Invalid FOR controls 102 U */
#define INVMOD 38 /* Invalid OPEN mode 21 F */
#define INVMS 39 /* Invalid mode:submode 220 I */
#define INVOPT 40 /* Invalid option 221 I */
#define INVRNG 41 /* Invalid range value 222 U */
#define INVSMD 42 /* Invalid OPEN submode 223 I */
#define INVSW 43 /* Invalid switch 224 I */
#define IOERR 44 /* Input or output error 22 F */
#define KYNSAM 45 /* Key not same 53 F */
#define LINLNG 46 /* Line too long 23 F */
#define MAXSIZ 47 /* Maximum record size is: %u 225 I */
#define MRGERR 48 /* Merge error 226 U */
#define NOCALL 49 /* RETURN without CALL 2 U */
#define NODEV 50 /* Device is not available: %s 19 F */
#define NODUPS 51 /* No duplicates allowed on key 54 F */
#define NOEOFC 52 /* No EOF character found, used physical EOF 228 I */
#define NOFILE 53 /* File not found 18 F */
#define NOISAM 54 /* No ISAM present 55 U */
#define NOSPAC 55 /* No space for file 24 F */
#define NOTDBR 56 /* %s is not a DBR file 230 U */
#define NOTISM 57 /* Not an ISAM file 56 F */
#define NOTPAK 58 /* Field not packed in UNPAK 80 U */
#define NULERR 59 /* 305 F */
#define NUMLNG 60 /* Number too long 15 F */
#define NUMRUN 61 /* Number of SORT run was: %u 231 I */
#define NUMSPC 62 /* Number specified was: %ld 232 I */
#define OPNERR 63 /* OPEN error 95 F */
#define OPENF 64 /* OPEN failure 300 U */
#define OPNINP 65 /* Cannot open file for input 234 I */
#define OPNOUT 66 /* Cannot open file for output 235 I */
#define OPNUPD 67 /* Cannot open file for update 236 I */
#define RBKXP 68 /* Right bracket expected 237 I */
#define READER 69 /* Cannot read input file 238 I */
#define RECBLK 70 /* Record must be a mult of block size 301 U */
#define RECLNG 71 /* Invalid record length 109 U */
#define RECSIZ 72 /* Record size specified was: %u 239 I */
#define RECNUM 73 /* Record number was: %ld 240 I */
#define RECXCL 74 /* Recursive XCALL 5 U */
#define RORKXP 75 /* Record or key expected 241 I */
#define RPEXP 76 /* Right parenthesis expected 242 I */
#define RUNERR 77 /* Internal runtime error, %s 104 U */
#define SPRFIL 78 /* Superseding existing file 32 F */
#define SRTFAI 79 /* SORT failure 243 F */
#define STKOVR 80 /* DBL Stack overflow 4 U */
#define STPMSG 81 /* STOP 244 U */
#define SUBSCR 82 /* Subscript error 7 U */
#define TTSBMD 83 /* Submode ignored for terminal open 245 I */
#define UNSUP 84 /* Unsupported command: %s 101 U */
#define VALRNG 85 /* Valid range is: %d to %u 246 I */
#define VALSPC 86 /* Value specified was: %ld 247 I */
#define WRILIT 87 /* Writing into a literal 8 U */
#define WROARG 88 /* Incorrect number of xcall arguments 6 U */
#define WRODEV 89 /* Input from a write-only device 12 F */
#define XOPENS 90 /* Too many OPEN files 117 U */
#define LIBSNF 91 /* Library subroutine %s not found in %s 248 U */
#define RECLOC 92 /* Record Locked 40 F */
#define INVACT 93 /* Invalid action for XCALL FATAL 309 U */
#define INVVAL 94 /* Invalid value for %s 249 I */
#define KEYSPC 95 /* Could not locate key with identifier %s 250 I */
#define SMERR 96 /* SORT or MERGE error 131 F */
#define FILFUL 97 /* Output file full 25 F */
#define NOATMP 98 /* No available arithmetic temporary space 253 U */
#define FILINU 99 /* File in use 38 F */
#define NOXCAL 100 /* Referenced undefined XCALL 254 F */

/* runtime function prototypes */

extern int dbltoi(char *, int); /* convert DBL decimal to 16-bit binary */
extern int itodbl(char *, int, int); /* convert 16-bit value to DBL decimal */
extern int fill(char *, char, int); /* fill string with character */
extern char *index(char *, char *, char); /* get ptr to char in a string */
extern int move(char *, char *, int); /* copy from one area to another */
extern char *sindex(char *, char *, char *); /* get ptr to substring */
extern int strcpy(char *, char *); /* copy one string to another */
extern int strlen(char *); /* length of string */
extern int strncmp(char *, char *, int); /* string compare with max length */
extern void rerror(int); /* DBL error generation, no return from call */
extern void pushdescr(DESCRIP *); /* push descriptor on DBL stack */
extern void ltodbl(char *, int, long); /* convert long to DBL string */
extern char *filpars(void); /* parse a DBL file name (use stack) */

/* don't know the prototypes for these:

from runtime.lib:
rmath rmisc retcop rmesag rstors rarith rindop rlpque rloop rtbl rdepop
riotty rioutl rxcall rstart newmem rcomport rcopyr printf ropen rstr
btree btree1 btreeu rprims riops rdebug1 rdebug2 rdebug3 rdisps rstmgi
rmerge rsort rsrtu rsrtd rsrt1 rsrt2 rmrgn rmrgi rmrgd pp sysprm strprm
uxtime w rcpydat

from c.lib:
Note that these are documented in Microsoft C.
affaldiv affalmul affalrem affalshl affalshr affauldi affaulre affaulsh
afldiv aflmul aflrem aflshl aflshr afnaldiv afnalmul afnalrem afnalshl
afnalshr afnauldi afnaulre afnaulsh afuldiv afulrem afulshr anfaldiv
anfalmul anfalrem anfalshl anfalshr anfauldi anfaulre anfaulsh anldiv
anlmul anlrem anlshl anlshr annaldiv annalmul annalrem annalshl annalshr
annauldi annaulre annaulsh anuldiv anulrem anulshr anllrot afllrot anlrrot
aflrrot crt0 crt0dat crt0msg crt0fp chkstk chksum stdargv stdenvp nmsghdr
fmsghdr stdalloc dosret _setargv wild fclose flushall fopen fprintf fread
fscanf fwrite printf scanf _cflush _file _filbuf _flsbuf _freebuf _getbuf
_open _sftbuf fflush input output stream fputc fgetc ungetc close lseek
open read write stackava txtmode nmalloc fmalloc amalloc calloc brkctl
strcat (strcpy) strcmp (strlen) strncat strncpy (strncmp) atoi atol atof atox
itoa ltoa _fptostr ultoa tolower toupper abort cmiscdat ctype getenv
isatty perror putenv div apisim kbhit getch int86 ldiv lmul lrem lshl lshr
uldiv ulrem ulshr bldiv blmul blrem blshl blshr buldiv bulrem bulshr hdiff
afhdiff anhdiff diffhlp _tmpoff clearerr closeall fdopen fgetchar fgetpos
fgets fputchar fputs freopen fseek fsetpos ftell gets getw puts putw rewind
rmtmp setbuf setvbuf sprintf sscanf tempnam tmpfile vfprintf vprintf vsprintf
creat eof sopen tell chsize dup flength mktemp setmode nheapchk nheapwal
nmsize realloc fheapchk fheapwal fmsize halloc xheapchk freect alloca brk
expand bdos cprintf cputs cscanf int86x intdos intdosx movedata segread
ungetch cgets inp outp putch asctime ctime days difftime ftime gmtime
localtim time tzset timeset utime dtoxtime _cinittm clock mktime strdate
strtime strchr stricmp strdup strnicmp strnset strrchr strrev strset
strlwr strupr strcspn strpbrk strspn strtok strstr memccpy memchr memmove
memicmp memcmp memcpy memset xtoa swab fcvt gcvt strtod strtol abs bsearch
doserr labslfind longdiv lsearch onexit qsort raise rand setjmp signal
_strerr syserr umask wrt2err ovlm6l lrotl lrotr rotl rotr strerror splitpat
searchen makepath qcdbrt cenvarg doexec dospawn execl execle execlp execlpe
execv execve execvp execvpe execmsg spawnl spawnle spawnlp spawnlpe spawnv
spawnve spawnvp spawnvpe system execload access chmod dir fstat getcwd
getpid locking rename stat unlink allocmem b_disk b_equipl b_keybrd b_memsiz
b_print b_serial b_timofd chainint d_close d_creat d_getvec d_find d_gfile
d_gftime d_keep d_open d_rdwr d_setvec d_sfile d_sftime disable diskfree
enable freemem getdate getdrive gettime harderr hardretn inpw outpw
setblock setdate setdrive settime xmdnload xmupload asixsend asixrecv
asixack asixnak asixpref asimodem asiputs asigets asiputb asigetb asiwgets
asiwgetb _asiputd _asigetd asireset asiclear asputs asputc asgetc asilstat
asibstat asimstat asilrst asimrst asierst asixrst asicheck asirchk asixon
asiflow asixoff asihold isrchk asigetpa asiresum asibreak gettxfre getrxcnt
asidiag _iswhat _isstat asishare asipeek asiwpeek asiputc asigetc asiwgetc
asiopen asiinit asistartasrts asdtr asisetv asiquit aschkcnl asifirst
_asifirs _asiquit _assti _asrts _asdtr _asirese _asiresu _asihold _asistar
_asiinit _asibrea _asidiag _asgetba kbd timer machine _asitime

from dlib.lib
acchr ascii ascr5 btod chnsts date decml defdev delet dflag dtob envrn
error ertxt fatal (fill) filnm flags flwid gline instr isclr iskey issts
kill len money msgrs msgsv netx paint pak pointer r5asc randm rcflg rcvid
renam retclr rstat runjb serial unpak dachr size spawn time tnmbr trim
ttsts versn wait zcsdz initport modname cmdln getlog dblsxw dblsss
*/
