/* lcopy.c
 *
 * DBL XCALL subroutine LCOPY to do LEX unsquashing.
 *
 * This C subroutine is used by SIM Donor package.
 * and works with MS-DOS DBL version 4.30 and LEX-86 version 9A.
 * It probably works with DBL 4.21, but NOT with DBL 4.19c.
 *
 * This is a fairly close port of LCOPY.49C, which is an assembly
 * language routine.  This can probably be optimized considerably,
 * though I am hoping Microsoft C 5.1 will do a good job of optimizing.
 *
 * Remark: Expands NULL (CR) to CRLF.
 *
 *	Programmer:	John Dudeck, SIM, Niamey, Niger
 *	Date:		12-May-89
 *
 * DBL calling sequence:
 *	XCALL LCOPY (INBUF,OTBUF,INDEX,SQSH)
 *
 * DBL XCALL Parameters:
 * INBUF	,A	; IN-String to transfer to output with unsquashing.
 * OTBUF	,A	; OUT-Output buffer.
 * INDEX	,D	; IN/OUT-Offset into output buffer.
 * SQSH		,A	; IN-Char to use for unsquashing.
 *
 * Function:
 * The subroutine call must do the following:
 * Copy chars from INBUF to OTBUF which is indexed by INDEX.
 * INDEX is incremented for each character transferred to OUTPUT.
 * If an input character is in the range 1 to 31 decimal, it represents
 * the count of the number of occurrences of SQSH that are 
 * to be transferred to OTBUF in place of the input character.
 * If the input character is NULL (representing CR) it is expanded to CRLF.
 * Leave INDEX pointing to next free cell in OTBUF or to end of OTBUF
 * if OTBUF is filled.  Do not output beyond end of OTBUF field.
 *
 * Build procedure.
 * The current DBL implementation (4.30) requires non-DBL subroutines
 * to be linked to the DBL runtime.  This requres Microsoft C.
 *
 * 1. To identify the C function as a DBL XCALL, use the program RXCALLS
 * to define the DBL XCALL name, and to give the equivalent C function name.
 * Assumes sim.xll is in current dir which is dbldir:.
 *
 * rxcalls rdlib.xll sim.xll
 *
 * This creates a new rxrefs.c.
 *
 * 2. Compile rxrefs.c using Microsoft C.
 *
 * cl -c -AM rxrefs.c
 *
 * 3. Compile the new C function.  Compile only, no link,
 * no stack checking.
 * For DBL 4.30, use medium model:
 * cl -c -AM -Gs lcopy.c
 * For DBL 4.31, use large model:
 * cl -c -AL -Gs lcopy.c
 *
 * 4. Relink the DBL runtime to include the new function(s).  This is done
 * with the DBL-supplied command file MAKEDBR.  MAKEDBR can take up to three
 * object files listed on command line.  Note that one object file can
 * contain any number of C functions.  Assumes that all .obj's are in current
 * directory which is dbldir:.  Uses Microsoft Linker supplied with MS C.
 *
 * makedbr lcopy
 */
#include "dbl.h"	/* DBL definitions and structures */
#define CR 13
#define LF 10

/* function lcopy */

lcopy(argtbl)
register DESCRIP **argtbl;
/*
 * argtbl is declared as pointer to pointer to structure of type DESCRIP.
 * In reality it points to the arg count, which is followed by
 * array of near pointers to descriptor blocks for each arg.  Note that
 * This is not fully encompassed in the declaration for argtbl.  A cast
 * is relied upon to handle the int arg. count.
 */
{
    DESCRIP *dscp;	/* argument description temporary pointer */
    char *inptr, *otptr, *otend, sqsh, c;
    int inlen, index;

/* Check arg count.  The first item pointed to by argtbl is an int.
 * (All the other items are pointers to variable descriptors). */

/*debug
printf("argcount = %d\n",(int)*argtbl); */

    if ((int)*argtbl++ != 4) rerror(WROARG);

/* Now find the DBL input args.
 * Start with INBUF. */
/* Check that arg is not null */
    if (!(dscp = *argtbl++)) rerror(ARGSIZ);
/* Put length in INLEN and pointer in INPTR. */

/*debug printf("inbuf length = %d\n",dscp->d_len);*/

    inlen = dscp -> d_len;

/*debug printf("inbuf ptr = %x\n",dscp->d_addr);*/

    inptr = dscp -> d_addr;

/*debug printf("inbuf cont = %s\n",dscp->d_addr);*/

/* Next OTBUF. */
/* Check that arg is not null */
    if (!(dscp = *argtbl++)) rerror(ARGSIZ);
/* Check that OTBUF is not literal. */
    if (dscp -> d_flags & LITRL) rerror(WRILIT);
/* Put pointer in OTPTR and pointer to end in OTEND. */

/*debug printf("otbuf ptr = %x\n",dscp->d_addr);*/
/*debug printf("otbuf length = %d\n",dscp->d_len);*/

    otptr = dscp -> d_addr;
    otend = otptr + dscp -> d_len;

/*debug printf("otbuf end = %x\n",otend);*/

/* Next INDEX. */
/* Check that arg is not null */
    if (!(dscp = *argtbl++)) rerror(ARGSIZ);
/* Check that INDEX is not literal. */
    if (dscp -> d_flags & LITRL) rerror(WRILIT);
/* Check that INDEX is decimal. */
    if (!(dscp -> d_flags & DECML)) rerror(DECXP);
/* Add INDEX to OTPTR to get pointer to start of output.
 * Start from 0 instead of 1. */
    index = dbltoi(dscp -> d_addr, dscp -> d_len);
    otptr += index - 1;

/*debug printf("index DBL = %10s\n",dscp -> d_addr);*/
/*debug printf("index int = %d\n",index);*/

/* Finally get SQSH char. */
/* Check that arg is not null */
    if (!(dscp = *argtbl)) rerror(ARGSIZ);
    sqsh = *dscp -> d_addr;

/*debug printf("sqsh = /%c/\n",sqsh);*/

/* Perform the schlepp operation. */
/* Check next output address. */
/* Decr input count. */
    while (otptr < otend && inlen--) {
/* Get input char.  Incr input pointer.*/
/* Is it a NULL (CR)?  Null represents CR in L9A VMF's.*/
/* Yes. Send CR to output buffer. */
      if (!(c = *inptr++)) {
        *otptr++ = CR;
/* Add a LF (First check buffer overflow). */
        if (otptr>=otend) break;
        *otptr++ = LF;
      }
/* Is it a squash char (in range 1 to 31 decimal)? */
      if (c >= 1 && c <= 31) {
/* Yes. Unsquash. */
/* Check output buffer overflow. */
/* Decrement SQSH count (the char's value is the count). Done unsquashing? */
/* Store sqsh char in output buffer. */
        while (otptr < otend && c--) *otptr++ = sqsh;
      }
/* No. Send the incoming char to output. */
      else *otptr++ = c;
    }
/* Done with copy operation. */
/* Point dscp back to descriptor block for INDEX. */
    dscp = *(--argtbl);
/* Compute new INDEX value. */
/* Point argtbl back to descriptor block for output buffer */
/* See how many bytes are used. Start at 1 instead of 0. */
    index = otptr - (*(--argtbl)) -> d_addr + 1;

/*debug printf("index int = %d\n",index);*/

/* Convert to BCD and store in INDEX arg. */
    itodbl(dscp -> d_addr, dscp -> d_len, index);

/*debug printf("index DBL = %10s\n",dscp -> d_addr);*/

/* Routine exit to DBL pgm. */
    return;
}
